<!--
BOSCH Security Systems (Grassbrunn)
Project: Magic.Panel
Author: Maria Lux
Created: 09-07-2013
$Revision: 1.2 $ 
Last locked:   $Date: 2016/11/10 14:28:34GMT $
Last change by $Author: Maria Lux (lux2ot) $
History: 
$Log: XSLT/conv-lt-2-14-2-to-2-14-2.xsl  $
Revision 1.2 2016/11/10 14:28:34GMT Maria Lux (lux2ot) 
oemFileName added to SUPPORT_INFO
Revision 1.1 2016/09/12 15:55:54CEST Maria Lux (lux2ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://bosch.com" xmlns:user2="http://user2.bosch.com">
  <xsl:include href="hashFunction.xsl"/>
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
  <!--##############  BEGIN Namspace cfg   ####################-->
  <cfg:Stylesheet mode="TRANSFORM" version="$Revision: 1.2 $" versionscope="ALL_FILES" backup="true" backupdir="cebackup"/>
  <cfg:Description lang="DE">Konvertiere Konfiguration mit Schemaversionen kleiner V2.14.2 zu Schema V2.14.2, Parameter newversion=2.14.2</cfg:Description>
  <cfg:Description lang="EN">Convert pre V2.14.2 configurations to  V2.14.2 parameter newversion= V2.14.2</cfg:Description>
  <!--##############  END Namspace cfg   ####################-->
  <xsl:include href="create-net.xsl"/>
  <xsl:include href="counter-2-x.xsl"/>
  <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
  <!-- ################################## NEW in VERSION 2.9.0 ######################## -->
  <xsl:template match="CONFIG_NETWORK">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'SUPPORT_INFO'">
            <xsl:element name="SUPPORT_INFO">
				<xsl:apply-templates select="*"/>
				<xsl:if test="oemLogoFilename = false()">
					<xsl:element name="oemLogoFilename"></xsl:element>
				</xsl:if>
            </xsl:element>
			<!-- the variables "temp1" and "temp2" will not be used; they are only needed to call the functions Set...Inserted-->
			 <xsl:variable name="temp1" select="user:SetCloudInserted(string('0'))"/>
			 <xsl:variable name="temp2" select="user:SetP2PInserted(string('0'))"/>
			 <xsl:choose>
				 <xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.2')">
					 <!-- the new structure already exists =>no need to do anything -->
				 </xsl:when>
					<xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.0')">
						 <xsl:if test="../CLOUD_DATA = true() and ../CLOUD_DATA/ipAddress != ''" >
								<!-- the variable "temp" will not be used; it is only needed to call the function SetCloudInserted-->
								<xsl:variable name="temp" select="user:SetCloudInserted(string('1'))"/>
								<!-- the CLOUD_DATA have to be moved one step lower -->
								<xsl:element name="REMOTE_SERVICES_NETWORK_DATA">
									<xsl:element name="CLOUD_DATA">
										<xsl:element name="ipAddress"><xsl:value-of select="../CLOUD_DATA/ipAddress"/></xsl:element>
										<xsl:element name="portNumber"><xsl:value-of select="../CLOUD_DATA/portNumber"/></xsl:element>
										<xsl:element name="siteName"><xsl:value-of select="../CLOUD_DATA/siteName"/></xsl:element>
										<xsl:element name="crl">172.31.31.1</xsl:element>
									</xsl:element>
								</xsl:element>
						 </xsl:if>
					</xsl:when>
					 <xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.0')=false()">
						<xsl:if test="../CM_SERVER = true() and ../CM_SERVER/ipAddress != '' and user:GetP2PInserted()='0'">
							<!-- the variable "temp" will not be used; it is only needed to call the function SetP2PInserted-->
							<xsl:call-template name="AddP2PData_CM">
								<xsl:with-param name="cmNetworkId"><xsl:value-of select="../CM_SERVER/cmNetworkId"/></xsl:with-param>
								<xsl:with-param name="ipAddress"><xsl:value-of select="../CM_SERVER/ipAddress"/></xsl:with-param>
								<xsl:with-param name="portNumber"><xsl:value-of select="../CM_SERVER/portNumber"/></xsl:with-param>
							</xsl:call-template>
						  <xsl:variable name="temp" select="user:SetP2PInserted(string('1'))"/>
						</xsl:if>
					 </xsl:when>
				</xsl:choose>
				<xsl:if test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
					<xsl:if test="user:GetCloudInserted()='0' and user:GetP2PInserted()='0'">
						 <xsl:if test="//TRANSFER[isTeleservice='ST_YES' and useIPTeleservice='ST_YES']">
						 <!-- at least one panel uses peer-to-peer teleservice -->
							  <xsl:call-template name="AddP2PData"/>
							  <xsl:variable name="temp" select="user:SetP2PInserted(string('1'))"/>
						 </xsl:if>
					</xsl:if>
				</xsl:if>
            <!-- correct level of (remote) network operators; the highest level wins if there are different levels assigned -->
			<xsl:if test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
				<xsl:choose>
					<xsl:when test="//OPERATOR[id=10001 and level='4'] = true()">
					<!-- at least one operator with level 4 existing => highest level is 4 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('4'))"/>
					</xsl:when>
					<xsl:when test="//OPERATOR[id=10001 and level='3'] = true()">
					<!-- at least one operator with level 3 existing => highest level is 3 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('3'))"/>
					</xsl:when>
					<xsl:when test="//OPERATOR[id=10001 and level='2'] = true()">
					<!-- at least one operator with level 2 existing => highest level is 2 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('2'))"/>
					</xsl:when>
					<xsl:when test="//OPERATOR[id=10001 and level='1'] = true()">
					<!-- at least one operator with level 1 existing => highest level is 1 -->
						<!-- the variable "temp" will not be used; it is only needed to call the function SetHighestRemoteOperatorLevel-->
						<xsl:variable name="temp" select="user:SetHighestRemoteOperatorLevel(string('1'))"/>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- ################################## END VERSION 2.9.0 ######################## -->
  <!-- ################################## NEW in VERSION 2.13.2 ######################## -->
  <xsl:template match="CM_SERVER">
	  <xsl:choose>
		    <xsl:when test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
				  <!-- remove it; it has been copied already if necessary -->
			</xsl:when>
			<xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.2')">
				  <!-- copy it -->
				  <xsl:element name="CM_SERVER">
					 <xsl:apply-templates select="*"/>
				  </xsl:element>
			</xsl:when>
		</xsl:choose>
  </xsl:template>
  <xsl:template match="CLOUD_DATA">
	  <xsl:choose>
		    <xsl:when test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
				  <!-- remove it; it has been copied already if necessary -->
			</xsl:when>
			<xsl:when test="user:IsVersionGreaterOrEqual ($ConvertedFrom, '2.13.2')">
				  <!-- copy it -->
				  <xsl:element name="CLOUD_DATA">
						 <xsl:apply-templates select="*"/>
				  </xsl:element>
			</xsl:when>
		</xsl:choose>
  </xsl:template>
  <xsl:template match="IP_Teleservice">
	  <xsl:element name="IP_TELESERVICE">
		  <xsl:element name="isAutoAnswerEnabled"><xsl:value-of select="isAutoAnswerEnabled"></xsl:value-of></xsl:element>
		  <xsl:element name="isEnabled"><xsl:value-of select="isEnabled"></xsl:value-of></xsl:element>
	  </xsl:element>
  </xsl:template>
  <xsl:template match="RemoteMonitoring">
	  <xsl:element name="REMOTE_MONITORING">
		  <xsl:element name="isEnabled"><xsl:value-of select="isEnabled"></xsl:value-of></xsl:element>
	  </xsl:element>
  </xsl:template>
  <!-- ################################## END VERSION 2.13.2 ######################## -->
  <!-- ################################## NEW in VERSION 2.10.0 ######################## -->
  <!-- the parameter newversion is automatically set by the TrafoValidate engine to the value of 'toVersion' of the conversion which is actually performed.
        Thus the element HEADER/dataVersion is set automatically to the new version.
  -->
  
  
  <!--  new template in 2.10 because there is a new element within TRANSFER -->
  <xsl:template match="TRANSFER">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="TRANSFER">
		<xsl:apply-templates select="siType"/>
		<xsl:apply-templates select="siNumber"/>
		<xsl:apply-templates select="subNumber"/>
		<xsl:apply-templates select="label"/>
		<xsl:apply-templates select="isCallbackRequired"/>
		<xsl:apply-templates select="isAutoAnswerEnabled"/>
		<xsl:apply-templates select="isCallbackConfirmation"/>
    	<xsl:apply-templates select="isTeleservice"/>
		<xsl:apply-templates select="tfMaxPacketSize"/>
		<xsl:apply-templates select="tfMaxPacketInterleave"/>
		<xsl:apply-templates select="tfMaxResendDistance"/>
		<xsl:apply-templates select="tfMaxParallelConnections"/>
		<xsl:apply-templates select="tfMaxSendMsgBuffers"/>
		<xsl:apply-templates select="maxPipeBytepoolSize"/>
		<xsl:apply-templates select="maxPipeMsgBlocks"/>
		<xsl:apply-templates select="maxPacketCacheSize"/>
		<xsl:apply-templates select="sessionTimeoutS"/>
		<xsl:apply-templates select="noDataTimeoutS"/>
		<xsl:apply-templates select="tfPacketCRCType"/>
		<xsl:apply-templates select="callback1"/>
		<xsl:apply-templates select="callback2"/>
		<xsl:apply-templates select="callback3"/>
		<xsl:apply-templates select="ATMODEM"/>
		<xsl:apply-templates select="OB_UART"/>
	</xsl:element>
  </xsl:template>

  <!-- For existing OB_UART -->
  <xsl:template match="OB_UART">
	<xsl:element name="OB_UART">
		<xsl:apply-templates select="*"/>
    </xsl:element>
  </xsl:template>
  <!-- For existing ATMODEM -->
  <xsl:template match="ATMODEM">
	<xsl:element name="ATMODEM">
		<xsl:apply-templates select="*"/>
    </xsl:element>
  </xsl:template>
  <!-- ################################## END VERSION 2.10.0 ######################## -->
  <!-- ################################## NEW in VERSION 2.0.1 ######################## -->
  <!-- Remove all network data from local configuration -->
  <!-- CHANNEL/target -->
  <xsl:template match="CHANNEL/target">
    <xsl:element name="target">
      <xsl:choose>
        <xsl:when test="contains(string(.),'MP_SI_PANEL')">
          <xsl:text>MP_SI_PANEL.1.0</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- NEW TRIGGER_STATE and NEW CONDITION_STATE with isRemote-->
  <xsl:template match="CONDITION_STATE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="isRemote = false()">
        <xsl:element name="isRemote">
          <xsl:text>ST_NO</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <xsl:template match="TRIGGER_STATE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
      <xsl:choose>
  <!--  item 225130 in Designspec FPA500 Maintenance 2.8 -->
        <xsl:when test="name() = 'oldstate' and . != 'MP_ET_NORMAL_DAY' and ../newstate = 'MP_ET_PAS_WAIT_FOR_ACK'">
        <xsl:element name="oldstate">
          <xsl:text>MP_ET_NORMAL_DAY</xsl:text>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
        <xsl:apply-templates select="."/>
        </xsl:otherwise>
      </xsl:choose>
      </xsl:for-each>
      <xsl:if test="isRemote = false()">
        <xsl:element name="isRemote">
          <xsl:text>ST_NO</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- ADD NODE REPLICATED_SIS-->
  <xsl:template match="EXPORTS">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="EXPORTS">
      <xsl:element name="netCRC">
        <xsl:value-of select="netCRC"/>
      </xsl:element>
      <xsl:element name="REPLICATED_SIS">
        <xsl:apply-templates select="REPLICATED_SIS/*"/>
      </xsl:element>
      <xsl:element name="REPLICATED_COUNTERS">
        <xsl:apply-templates select="REPLICATED_COUNTERS/*"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- ADD NODE USED_SIS-->
  <xsl:template match="IMPORTS">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="IMPORTS">
      <xsl:element name="netCRC">
        <xsl:value-of select="netCRC"/>
      </xsl:element>
      <xsl:element name="USED_SIS">
        <xsl:apply-templates select="USED_SIS/*"/>
      </xsl:element>
      <xsl:element name="USED_COUNTERS">
        <xsl:apply-templates select="USED_COUNTERS/*"/>
      </xsl:element>
	  <xsl:if test="USED_OFFSET_TABLES = true()">
		<xsl:apply-templates select="."/>
	  </xsl:if>
    </xsl:element>
  </xsl:template>
  <!--  -->
  <xsl:template match="USED_OFFSET_TABLE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template match="OFFSET_TABLE">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
		<xsl:choose>
			<xsl:when test="name() = 'fbf'">
				<!-- fbf has to be empty; it is no longer used -->
				<xsl:element name="fbf"></xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="."/>
			</xsl:otherwise>
		</xsl:choose>
      </xsl:for-each>
      <xsl:if test="memory=false()">
        <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE"/>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <xsl:template match="GLOBAL_OFFSET_TABLE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
		<xsl:choose>
			<xsl:when test="name() = 'fbf'">
				<!-- fbf has to be empty; it is no longer used -->
				<xsl:element name="fbf"></xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="."/>
			</xsl:otherwise>
		</xsl:choose>
      </xsl:for-each>
      <xsl:if test="memory=false()">
        <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE"/>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <xsl:template match="CTIE">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="externallyUsed = false()">
        <xsl:element name="externallyUsed">ST_NO</xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- ################################## NEW in VERSION 2.0.2 ######################## -->
  <!-- ADD PANEL/troubleCausesAlarm -->
  <xsl:template match="PANEL">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'resetMode'">
            <xsl:apply-templates select="."/>
            <xsl:if test="../troubleCausesAlarm = false()">
              <!-- if not already there, added in 2.0.2-->
              <xsl:element name="troubleCausesAlarm">ST_NO</xsl:element>
              <xsl:element name="colorProfileUsed">COLOR_PROFILE_1</xsl:element>
              <!-- cannot be there if troubleCausesAlarm is missing because was introduced later -->
            </xsl:if>
          </xsl:when>
          <xsl:when test="name() = 'troubleCausesAlarm'">
            <xsl:apply-templates select="."/>
            <xsl:if test="../colorProfileUsed = false()">
              <!-- if not already there, added in 2.8.3 -->
              <xsl:element name="colorProfileUsed">COLOR_PROFILE_1</xsl:element>
            </xsl:if>
          </xsl:when>
          <xsl:when test="name() = 'country'">
            <xsl:if test="text() = 'YU'">
              <!-- country Yugoslavia was removed since it no longer exists; use Serbia instead; introduced in 2.10.0 -->
              <xsl:element name="country">RS</xsl:element>
            </xsl:if>
            <xsl:if test="text() != 'YU'">
            <xsl:apply-templates select="."/>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template match="OPERATOR">
	  <xsl:element name="OPERATOR">
		  <xsl:choose>
				<xsl:when test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
					<xsl:variable name="highestLevel" select="user:GetHighestRemoteOperatorLevel()"/>
					<xsl:choose>
					  <xsl:when test="id = '10001'">
						<xsl:choose>
							<xsl:when test="$highestLevel='4'">
								<xsl:element name="id">
									<xsl:text>10001</xsl:text>
								</xsl:element>
								<xsl:element name="label">
									<xsl:value-of select="./label"/>
								</xsl:element>
								<xsl:element name="level">
									<xsl:text>4</xsl:text>
								</xsl:element>
								<xsl:element name="scope">
									<xsl:value-of select="./scope"/>
								</xsl:element>
								<xsl:element name="pwd">
								   <xsl:choose>
										<xsl:when test="./pwd = ''">
											<xsl:text>4A154B2B</xsl:text>
										</xsl:when>
										<xsl:otherwise>
										<!-- a function has to be called this does not yet exist -->
											<xsl:value-of select="string(user2:HashPassword(string(./pwd)))"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
							</xsl:when>
							<xsl:when test="$highestLevel='3'">
								<xsl:element name="id">
									<xsl:text>10014</xsl:text>
								</xsl:element>
								<xsl:element name="label">
									<xsl:value-of select="./label"/>
								</xsl:element>
								<xsl:element name="level">
									<xsl:text>3</xsl:text>
								</xsl:element>
								<xsl:element name="scope">
									<xsl:value-of select="./scope"/>
								</xsl:element>
								<xsl:element name="pwd">
								   <xsl:choose>
										<xsl:when test="./pwd = ''">
											<xsl:text>4A154B2B</xsl:text>
										</xsl:when>
										<xsl:otherwise>
										<!-- a function has to be called this does not yet exist -->
											<xsl:value-of select="string(user2:HashPassword(string(./pwd)))"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
							</xsl:when>
							<xsl:when test="$highestLevel='2'">
								<xsl:element name="id">
									<xsl:text>10015</xsl:text>
								</xsl:element>
								<xsl:element name="label">
									<xsl:value-of select="./label"/>
								</xsl:element>
								<xsl:element name="level">
									<xsl:text>2</xsl:text>
								</xsl:element>
								<xsl:element name="scope">
									<xsl:value-of select="./scope"/>
								</xsl:element>
								<xsl:element name="pwd">
								   <xsl:choose>
										<xsl:when test="./pwd = ''">
											<xsl:text>4A154B2B</xsl:text>
										</xsl:when>
										<xsl:otherwise>
										<!-- a function has to be called this does not yet exist -->
											<xsl:value-of select="string(user2:HashPassword(string(./pwd)))"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
							</xsl:when>
							<xsl:when test="$highestLevel='1'">
								<xsl:element name="id">
									<xsl:text>10016</xsl:text>
								</xsl:element>
								<xsl:element name="label">
									<xsl:value-of select="./label"/>
								</xsl:element>
								<xsl:element name="level">
									<xsl:text>1</xsl:text>
								</xsl:element>
								<xsl:element name="scope">
									<xsl:value-of select="./scope"/>
								</xsl:element>
								<xsl:element name="pwd">
								   <xsl:choose>
										<xsl:when test="./pwd = ''">
											<xsl:text>4A154B2B</xsl:text>
										</xsl:when>
										<xsl:otherwise>
										<!-- a function has to be called this does not yet exist -->
											<xsl:value-of select="string(user2:HashPassword(string(./pwd)))"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
							</xsl:when>
						</xsl:choose>
					  </xsl:when>
					  <xsl:otherwise>
					<xsl:apply-templates select="*"/>
					  </xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="*"/>
				</xsl:otherwise>
			</xsl:choose>
	  </xsl:element>
  </xsl:template>
  <!-- hash password -->
  <xsl:template match="OPERATOR/pwd">
    <xsl:element name="pwd">
    <xsl:choose>
		<xsl:when test="user:IsVersionLess ($ConvertedFrom, '2.13.2')">
			<xsl:choose>
				<xsl:when test="text() = ''">
					<xsl:text>4A154B2B</xsl:text>
				</xsl:when>
				<xsl:otherwise>
				<!-- a function has to be called this does not yet exist -->
					<xsl:value-of select="string(user2:HashPassword(string(text())))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			  <xsl:value-of select="."/>
		</xsl:otherwise>
	</xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- ADD OPERATOR/scope-->
  <xsl:template match="OPERATOR/level">
    <xsl:element name="level">
      <xsl:value-of select="."/>
    </xsl:element>
    <!-- if not already there -->
    <xsl:if test="../scope = false()">
      <xsl:element name="scope">
        <xsl:choose>
          <xsl:when test="../id = '9' or ../id = '10001' or ../id = '10008'">
            <xsl:text>NETWORK</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>LOCAL</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- ADD OPERATOR_ADMIN/maxIdleTime-->
  <xsl:template match="OPERATOR_ADMIN/is24hMasterPwd">
    <xsl:element name="is24hMasterPwd">
      <xsl:value-of select="."/>
    </xsl:element>
    <!-- if not already there -->
    <xsl:if test="../maxIdleTime = false()">
      <xsl:element name="maxIdleTime">60</xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- ADD New Rights-->
  <xsl:template match="RIGHT_MANAGEMENT">
    <xsl:element name="RIGHT_MANAGEMENT">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'LEVEL'">
            <xsl:call-template name="UpdateLevel">
              <xsl:with-param name="LevelId" select="./id"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- Change RIGHT Configure -->
  <xsl:template match="RIGHT">
    <xsl:element name="RIGHT">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'action' and . = 'OPM_ACT_CONFIGURE' and ../type = 'OPM_CDT_CONFIGURE' and ../target = 'OPM_SI_MATCHALL'">
            <xsl:element name="{name()}">OPM_ACT_MATCHALL</xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- ADD new RIGHTS to LEVEL 1 and 3-->
  <xsl:template name="UpdateLevel">
    <xsl:param name="LevelId"/>
    <xsl:element name="LEVEL">
      <xsl:for-each select="./*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <!-- in LEVEL 1 there are 2 RIGHTs and id = 3 if not yet added-->
      <xsl:if test="$LevelId = '1' and count(./*) = 3">
        <xsl:call-template name="CreateRightLanguage"/>
      </xsl:if>
      <!-- in LEVEL 3  there are 9 RIGHTs and id = 10 if not yet added-->
      <xsl:if test="$LevelId = '3' and count(./*) = 10">
        <xsl:call-template name="CreateRightUART"/>
        <xsl:call-template name="CreateRightFireExt"/>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!--  RIGHT to change Language-->
  <xsl:template name="CreateRightLanguage">
    <xsl:element name="RIGHT">
      <xsl:element name="type">OPM_CDT_CONFIGURE</xsl:element>
      <xsl:element name="action">OPM_ACT_CHANGE</xsl:element>
      <xsl:element name="target">OPM_SI_LANGUAGE</xsl:element>
      <xsl:element name="on">ST_YES</xsl:element>
      <xsl:element name="off">ST_YES</xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- RIGHT to switch UART -->
  <xsl:template name="CreateRightUART">
    <xsl:element name="RIGHT">
      <xsl:element name="type">OPM_CDT_ACTIVATION</xsl:element>
      <xsl:element name="action">OPM_ACT_CHANGE</xsl:element>
      <xsl:element name="target">OPM_SI_UART</xsl:element>
      <xsl:element name="on">ST_YES</xsl:element>
      <xsl:element name="off">ST_YES</xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- RIGHT for Activate FireExt -->
  <xsl:template name="CreateRightFireExt">
    <xsl:element name="RIGHT">
      <xsl:element name="type">OPM_CDT_ACTIVATION</xsl:element>
      <xsl:element name="action">OPM_ACT_CONTINUOUS</xsl:element>
      <xsl:element name="target">OPM_SI_FIREEXTINGUISHER</xsl:element>
      <xsl:element name="on">ST_YES</xsl:element>
      <xsl:element name="off">ST_YES</xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- ################################## NEW in VERSION 2.0.3 ######################## -->
  <!-- ONBOARD is modified -->
  <!--  1. GROUND only if FPA5000, not for RK -->
  <!--  2. OB_INPUTS are inserted for FPA5000 and RK -->
  <!--  3. OB_POWER_INS are inserted for RK only -->
  <!--  4. (2.0.7) CANBUS 3x -->
  <xsl:template match="ONBOARD">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="ONBOARD">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
        <xsl:if test="name() = 'RS232' and ../CANBUS=false()">
          <xsl:call-template name="AddCANBUS">
            <xsl:with-param name="PortNbr">1</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="AddCANBUS">
            <xsl:with-param name="PortNbr">2</xsl:with-param>
          </xsl:call-template>
          <xsl:call-template name="AddCANBUS">
            <xsl:with-param name="PortNbr">3</xsl:with-param>
          </xsl:call-template>
          <xsl:if test="../ETHERNET = false()">
            <xsl:call-template name="AddETHERNET">
              <xsl:with-param name="PortNbr">1</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="AddETHERNET">
              <xsl:with-param name="PortNbr">2</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
        <xsl:if test="name() = 'CANBUS' and ./port = '3' and ../ETHERNET = false()">
          <xsl:call-template name="AddETHERNET">
            <xsl:with-param name="PortNbr">1</xsl:with-param>
          </xsl:call-template>
          <xsl:if test="user:IsHW_C(string(ancestor::NODE/nodeType)) = true()">
            <xsl:call-template name="AddETHERNET">
              <xsl:with-param name="PortNbr">2</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
      <xsl:if test="OB_INPUTS=false()">
        <xsl:call-template name="AddOB_INPUTS"/>
      </xsl:if>
      <xsl:if test="user:IsRemoteKeypad(string(ancestor::NODE/nodeType)) = true() and OB_POWER_INS = false()">
        <xsl:call-template name="AddOB_POWER_INS"/>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- GROUND only if FPA5000, not for RK and also if no anchestor::NODE like in pre 2.0 configurations -->
  <xsl:template match="GROUND">
    <xsl:if test="ancestor::NODE=false() or user:IsPanel(string(ancestor::NODE/nodeType)) = true()">
      <xsl:element name="GROUND">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- in case of beeing a remote keypad no SETs in SET_ADMIN
   <xsl:template match="SETS_ADMIN">
      <xsl:element name="SETS_ADMIN">
         <xsl:if test="ancestor::NODE=false() or ancestor::NODE/nodeType='FPA5000' or ancestor::NODE/nodeType='FPA1200_EN'">
            <xsl:apply-templates/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
  is dropped 21.5. 2010 after detecting that it is possible to create sets in FMR, 
  which than will be dropped on the next conversion -->
  <!-- -->
  <xsl:template name="AddETHERNET">
    <xsl:param name="PortNbr"/>
    <xsl:element name="ETHERNET">
      <xsl:element name="port">
        <xsl:value-of select="$PortNbr"/>
      </xsl:element>
      <xsl:element name="siType">MP_SI_NETWORK_LINE</xsl:element>
      <xsl:element name="enabled">
        <xsl:choose>
          <xsl:when test="$PortNbr = '1' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[3]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:when test="$PortNbr = '2' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[4]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '1' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '2' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>ST_NO</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="ETHERNET">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:choose>
      <xsl:when test="user:IsHW_C(string(ancestor::NODE/nodeType)) = false() and port = '2'">
    </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name()}">
          <xsl:apply-templates select="*"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- -->
  <xsl:template name="AddCANBUS">
    <xsl:param name="PortNbr"/>
    <xsl:element name="CANBUS">
      <xsl:element name="port">
        <xsl:value-of select="$PortNbr"/>
      </xsl:element>
      <xsl:element name="siType">MP_SI_CANBUS</xsl:element>
      <xsl:element name="enabled">
        <xsl:choose>
          <xsl:when test="$PortNbr = '2' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[1]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:when test="$PortNbr = '3' and ancestor::NODE/NET_INTERFACES/NET_INTERFACE[2]/connectedToNetlineNbr = '0'">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '2' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <!--  pre 2.0 configurations don not have anchestor::NODE, connectedToNetlineNbr is set to 0 in create-net.xsl-->
          <xsl:when test="$PortNbr = '3' and ancestor::NODE=false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>ST_YES</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template name="AddOB_INPUTS">
    <xsl:element name="OB_INPUTS">
      <xsl:element name="slot">136</xsl:element>
      <xsl:call-template name="AddINPUT">
        <xsl:with-param name="PortNbr" select="'1'"/>
      </xsl:call-template>
      <xsl:call-template name="AddINPUT">
        <xsl:with-param name="PortNbr" select="'2'"/>
      </xsl:call-template>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template name="AddINPUT">
    <xsl:param name="PortNbr"/>
    <xsl:element name="INPUT">
      <xsl:element name="siType">MP_SI_POINT</xsl:element>
      <xsl:element name="port">
        <xsl:value-of select="$PortNbr"/>
      </xsl:element>
      <xsl:element name="siNumber">0</xsl:element>
      <xsl:element name="subNumber">0</xsl:element>
      <xsl:element name="label"/>
      <xsl:element name="bypassable">ST_YES</xsl:element>
      <xsl:element name="blockable">ST_YES</xsl:element>
      <xsl:element name="usageType">MP_UT_SUPERVISORY</xsl:element>
      <xsl:element name="dayNightMode">ST_NO</xsl:element>
      <xsl:element name="andDetector">ST_NO</xsl:element>
      <xsl:element name="andZoneNr">0</xsl:element>
      <xsl:element name="andLatching">ST_NO</xsl:element>
      <xsl:element name="resetOutput">0.0.0.0</xsl:element>
      <xsl:element name="resetTime">0</xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template name="AddOB_POWER_INS">
    <xsl:element name="OB_POWER_INS">
      <xsl:element name="slot">137</xsl:element>
      <xsl:call-template name="AddMAINPOWER"/>
      <xsl:call-template name="AddMAINPOWER"/>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template name="AddMAINPOWER">
    <xsl:element name="MAINPOWER">
      <xsl:element name="siType">MP_SI_MAINPOWER</xsl:element>
      <xsl:element name="siNumber">0</xsl:element>
      <xsl:element name="label"/>
      <xsl:element name="delayForTrouble">0</xsl:element>
    </xsl:element>
  </xsl:template>
  <!--  LOGICAL_GROUPING is modified -->
  <!-- BEGIN ################################## FOR less 1.3.0 VERSIONS  ######################## -->
  <!--  new element MTS from old FAT, this template is implemented in included conv-lt-1-3-0-to-1-3-0.xsl too, but is found first here if target is 2.0.7 -->
  <xsl:template match="LOGICAL_GROUPING/FAT_ADMIN/FAT">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="MTS">
      <xsl:element name="subType">
        <xsl:choose>
          <xsl:when test="fat != $NOT_TRANS or coupler != $NOT_TRANS">
            <xsl:text>FMS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>FAT</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:element name="redundantSiNumber">
        <xsl:text>0</xsl:text>
      </xsl:element>
      <xsl:element name="TRANSMISSION_TABLE">
        <xsl:for-each select="*">
          <xsl:choose>
            <xsl:when test="name() = 'UART' or name() = 'OB_UART' or name() = 'siNumber' or name() = 'label' or name() = 'connectedWith'">
              <!-- do nothing -->
            </xsl:when>
            <xsl:otherwise>
              <xsl:element name="{name()}">
                <xsl:choose>
                  <xsl:when test=". = $NOT_TRANS">
                    <xsl:text>ST_NO</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>ST_YES</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:element>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
        <xsl:call-template name="ExtendTRANSMISSION_TABLE"/>
      </xsl:element>
      <xsl:element name="MTS_CONNECTION">
        <xsl:element name="connectedWith">
          <xsl:value-of select="connectedWith"/>
        </xsl:element>
        <xsl:for-each select="*">
          <xsl:if test="name() = 'UART' or name() = 'OB_UART'">
            <xsl:element name="{name()}">
              <xsl:apply-templates/>
            </xsl:element>
          </xsl:if>
        </xsl:for-each>
        <xsl:call-template name="CreateProtocolValues"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- replace existing FAT_ADMIN by MTS_ADMIN and insert ADDRESSMANAGMENT after it in LOGICAL_GROUPING -->
  <!-- , this template is implemented in included conv-lt-1-3-0-to-1-3-0.xsl too, but is found first here if target is 2.0.7 -->
  <xsl:template match="NETWORK/PANEL/LOGICAL_GROUPING/FAT_ADMIN">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:if test="FAT">
      <xsl:element name="MTS_ADMIN">
        <xsl:for-each select="FAT">
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:element>
      <xsl:element name="ADDRESS_MANAGEMENT">
        <xsl:call-template name="CreateGlobalOffsetTableFromLess130"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <xsl:template match="MTS_ADMIN">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template match="TRANSMISSION_TABLE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
		<xsl:choose>
			<xsl:when test="name() = 'fbf'">
				<!-- fbf has to be ST_NO; it is no longer used -->
				<xsl:element name="fbf">ST_NO</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="."/>
			</xsl:otherwise>
		</xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- Create GLOBAL_OFFSET_TABLE from less 1.3.0 versions-->
  <xsl:template name="CreateGlobalOffsetTableFromLess130">
    <xsl:element name="GLOBAL_OFFSET_TABLE">
      <xsl:element name="panel">
        <xsl:if test="FAT/panel != $NOT_TRANS">
          <xsl:value-of select="FAT/panel"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="point">
        <xsl:if test="FAT/point != $NOT_TRANS">
          <xsl:value-of select="FAT/point"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="module">
        <xsl:if test="FAT/module != $NOT_TRANS">
          <xsl:value-of select="FAT/module"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="coupler">
        <xsl:if test="FAT/coupler != $NOT_TRANS">
          <xsl:value-of select="FAT/coupler"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="control">
        <xsl:if test="FAT/control != $NOT_TRANS">
          <xsl:value-of select="FAT/control"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="input">
        <xsl:if test="FAT/input != $NOT_TRANS">
          <xsl:value-of select="FAT/input"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="citytie">
        <xsl:if test="FAT/citytie != $NOT_TRANS">
          <xsl:value-of select="FAT/citytie"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="fireextinguisher">
        <xsl:if test="FAT/fireextinguisher != $NOT_TRANS">
          <xsl:value-of select="FAT/fireextinguisher"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="nac">
        <xsl:if test="FAT/nac != $NOT_TRANS">
          <xsl:value-of select="FAT/nac"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="buzzer">
        <xsl:if test="FAT/buzzer != $NOT_TRANS">
          <xsl:value-of select="FAT/buzzer"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="hvac">
        <xsl:if test="FAT/hvac != $NOT_TRANS">
          <xsl:value-of select="FAT/hvac"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="doorholder">
        <xsl:if test="FAT/doorholder != $NOT_TRANS">
          <xsl:value-of select="FAT/doorholder"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="keydepot">
        <xsl:if test="FAT/keydepot != $NOT_TRANS">
          <xsl:value-of select="FAT/keydepot"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="status">
        <xsl:if test="FAT/status != $NOT_TRANS">
          <xsl:value-of select="FAT/status"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="dialer">
        <xsl:if test="FAT/dialer != $NOT_TRANS">
          <xsl:value-of select="FAT/dialer"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="printer">
        <xsl:if test="FAT/printer != $NOT_TRANS">
          <xsl:value-of select="FAT/printer"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="fat">
        <xsl:if test="FAT/fat != $NOT_TRANS">
          <xsl:value-of select="FAT/fat"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="fbf">
        <xsl:if test="FAT/fbf != $NOT_TRANS">
          <xsl:value-of select="FAT/fbf"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="set">
        <xsl:if test="FAT/set != $NOT_TRANS">
          <xsl:value-of select="FAT/set"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="auxpower">
        <xsl:if test="FAT/auxpower != $NOT_TRANS">
          <xsl:value-of select="FAT/auxpower"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="battery">
        <xsl:if test="FAT/battery != $NOT_TRANS">
          <xsl:value-of select="FAT/battery"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="mainpower">
        <xsl:if test="FAT/mainpower != $NOT_TRANS">
          <xsl:value-of select="FAT/mainpower"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="railpower">
        <xsl:if test="FAT/railpower != $NOT_TRANS">
          <xsl:value-of select="FAT/railpower"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="ground">
        <xsl:if test="FAT/ground != $NOT_TRANS">
          <xsl:value-of select="FAT/ground"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="loop">
        <xsl:if test="FAT/loop != $NOT_TRANS">
          <xsl:value-of select="FAT/loop"/>
        </xsl:if>
      </xsl:element>
      <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE">
        <xsl:with-param name="Complete" select="true()"/>
      </xsl:call-template>
    </xsl:element>
  </xsl:template>
  <!-- END ################################## FOR less 1.3.0 VERSIONS  ######################## -->
  <!-- ################################## FOR all 1.x VERSIONS  ######################## -->
  <xsl:template match="LOGICAL_GROUPING">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="LOGICAL_GROUPING">
      <xsl:for-each select="*">
        <!--  2.0.7 configs have a mandatory ADDRESS_MANAGEMENT before COUNTER_ADMIN
                 pre 1.3.0  have no ADDRESS_MANAGEMENT at all:
                    1. having an FAT_ADMIN are handled in template match="NETWORK/PANEL/LOGICAL_GROUPING/FAT_ADMIN" above 
                    2. having no FAT_ADMIN are detected here, the ADDRESS_MANAGEMENT including the extensions made in 2.0.4 is inserted 
                  1.3.0 have an optinal ADRRESS_MAGEMENT if an MTS_ADMIN is configured:
                   1. having an ADRRESS_MAGEMENT: the values of the existing have to be taken and the new 2.0.4 extensions have to be appended 
                   2. having no ADRRESS_MAGEMENT: ADDRESS_MANAGEMENT with default values including the extensions made in 2.0.4 is inserted
        -->
        <xsl:if test="name()='COUNTER_ADMIN' and ../FAT_ADMIN=false()">
          <xsl:choose>
            <xsl:when test="../ADDRESS_MANAGEMENT=false()">
              <!-- add the mandatory ADDRESS_MANAGEMENT with default values including the extensions made in 2.0.4  -->
              <xsl:call-template name="AddADDRESS_MANAGEMENT"/>
            </xsl:when>
            <xsl:otherwise>
              <!--  copy the existing ADDRESS_MANAGEMENT and add the extension made in 2.0.4  -->
              <xsl:call-template name="MoveADDRESS_MANAGEMENT">
                <xsl:with-param name="From" select="../ADDRESS_MANAGEMENT/GLOBAL_OFFSET_TABLE/*"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <!-- There is a bug that TIME_CONTROL is lost in older configurations although it is mandatory -->
      <xsl:if test="TIME_CONTROL = false()">
        <xsl:element name="TIME_CONTROL">
          <xsl:call-template name="FillTimeControl"/>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!--  Create a new minimal TIME_CONTROL which can be edited by RPS -->
  <xsl:template name="FillTimeControl">
    <xsl:element name="CHANNELS">
      <xsl:element name="CHANNEL">
        <xsl:element name="id">20</xsl:element>
        <xsl:element name="target">MP_SI_PANEL.1.0</xsl:element>
        <xsl:element name="ON_ACTION"/>
        <xsl:element name="OFF_ACTION"/>
      </xsl:element>
    </xsl:element>
    <xsl:element name="PROGRAMS"/>
    <xsl:element name="DAYS"/>
  </xsl:template>
  <!--   delete ADDRESS_MANAGMENT at the place it is actually-->
  <xsl:template match="ADDRESS_MANAGEMENT"/>
  <!--  EXTENDED STRUCTURE of 2.0.4  -->
  <xsl:template name="MoveADDRESS_MANAGEMENT">
    <xsl:param name="From"/>
    <xsl:element name="ADDRESS_MANAGEMENT">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
      <xsl:element name="GLOBAL_OFFSET_TABLE">
        <xsl:for-each select="$From">
          <xsl:element name="{name()}">
			  <xsl:choose>
				<xsl:when test="name() = 'fbf'">
					<!-- fbf has to be empty; it is no longer used -->
					<xsl:text></xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="."/>
				</xsl:otherwise>
				</xsl:choose>
          </xsl:element>
        </xsl:for-each>
        <xsl:if test="$From/../memory = false()">
          <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE"/>
        </xsl:if>
        <xsl:if test="$From/../vas = false()">
          <xsl:element name="vas">3425</xsl:element>
        </xsl:if>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!--  EXTENDED STRUCTURE of 2.0.4 -->
  <xsl:template name="AddADDRESS_MANAGEMENT">
    <xsl:element name="ADDRESS_MANAGEMENT">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
      <xsl:element name="GLOBAL_OFFSET_TABLE">
        <xsl:element name="panel"/>
        <xsl:element name="point">0</xsl:element>
        <xsl:element name="module">1500</xsl:element>
        <xsl:element name="coupler"/>
        <xsl:element name="control">1000</xsl:element>
        <xsl:element name="input"/>
        <xsl:element name="citytie">2100</xsl:element>
        <xsl:element name="fireextinguisher">2200</xsl:element>
        <xsl:element name="nac">1600</xsl:element>
        <xsl:element name="buzzer"/>
        <xsl:element name="hvac"/>
        <xsl:element name="doorholder">2000</xsl:element>
        <xsl:element name="keydepot">2300</xsl:element>
        <xsl:element name="status"/>
        <xsl:element name="dialer"/>
        <xsl:element name="printer">2400</xsl:element>
        <xsl:element name="fat">2450</xsl:element>
        <xsl:element name="fbf"/>
        <xsl:element name="set"/>
        <xsl:element name="auxpower">2500</xsl:element>
        <xsl:element name="battery">2600</xsl:element>
        <xsl:element name="mainpower">2700</xsl:element>
        <xsl:element name="railpower">2800</xsl:element>
        <xsl:element name="ground">2900</xsl:element>
        <xsl:element name="loop">3000</xsl:element>
        <xsl:call-template name="ExtendGLOBAL_OFFSET_TABLE"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!--  -->
  <xsl:template name="ExtendGLOBAL_OFFSET_TABLE">
    <xsl:param name="Complete" select="false()"/>
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="memory">3100</xsl:element>
    <xsl:element name="canbus">3110</xsl:element>
    <xsl:element name="network">3105</xsl:element>
    <xsl:element name="networknode">3115</xsl:element>
    <xsl:element name="network_line">3400</xsl:element>
    <xsl:element name="topology">3405</xsl:element>
    <xsl:element name="netaddress">3415</xsl:element>
    <xsl:element name="vas">3425</xsl:element>
  </xsl:template>
  <!--  -->
  <xsl:template match="MTS/TRANSMISSION_TABLE">
    <xsl:element name="TRANSMISSION_TABLE">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="memory=false()">
        <xsl:call-template name="ExtendTRANSMISSION_TABLE"/>
      </xsl:if>
      <xsl:if test="vas=false()">
        <xsl:element name="vas">ST_YES</xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <xsl:template name="ExtendTRANSMISSION_TABLE">
    <xsl:element name="memory">ST_YES</xsl:element>
    <xsl:element name="canbus">ST_YES</xsl:element>
    <xsl:element name="network">ST_YES</xsl:element>
    <xsl:element name="networknode">ST_YES</xsl:element>
    <xsl:element name="network_line">ST_YES</xsl:element>
    <xsl:element name="topology">ST_YES</xsl:element>
    <xsl:element name="netaddress">ST_YES</xsl:element>
  </xsl:template>
  <!--  PRIORITIES are extended -->
  <xsl:template match="PRIORITIES">
    <xsl:element name="PRIORITIES">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <!-- missing watchdogRestart triggers the extension 1 -->
      <xsl:if test="watchdogRestart=false()">
        <xsl:call-template name="ExtendPRIORITIES_1"/>
      </xsl:if>
      <!-- missing warning_heat triggers the extension 2 -->
      <xsl:if test="warning_heat=false()">
        <xsl:call-template name="ExtendPRIORITIES_2"/>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- Extend Priorities -->
  <xsl:template name="ExtendPRIORITIES_1">
    <xsl:element name="watchdogRestart">3</xsl:element>
    <xsl:element name="pasWaitForAck">1</xsl:element>
    <xsl:element name="pasInvestigate">1</xsl:element>
    <xsl:element name="netConfigMismatch">1</xsl:element>
    <xsl:element name="unknownItem">1</xsl:element>
    <xsl:element name="missingItem">3</xsl:element>
    <xsl:element name="incompatibleSoftware">1</xsl:element>
    <xsl:element name="incompatibleNetProtocol">1</xsl:element>
  </xsl:template>
  <!-- Extend Priorities for 2.5.0-->
  <xsl:template name="ExtendPRIORITIES_2">
    <xsl:element name="warning_smoke">3</xsl:element>
    <xsl:element name="warning_heat">3</xsl:element>
    <xsl:element name="info_alarm">3</xsl:element>
    <xsl:element name="chemical">5</xsl:element>
  </xsl:template>
  <!-- RK_DATA are extended  by showReportsInLockedState -->
  <xsl:template match="RK_DATA">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="RK_DATA">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="showReportsInLockedState = false()">
        <xsl:element name="showReportsInLockedState">ST_YES</xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- NET_INTERFACE is extended  by CAN_PARAM -->
  <xsl:template match="NET_INTERFACE">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:choose>
      <xsl:when test="user:IsHW_C(string(ancestor::NODE/nodeType)) = false() and type='ETHERNET' and interfaceNbr='2'">
        <!-- do nothing and drop the NET_INTERFACE -->
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="NET_INTERFACE">
          <xsl:for-each select="*">
            <xsl:choose>
              <xsl:when test="name() = 'connectedToNetlineNbr'">
                <xsl:apply-templates select="."/>
                <!-- new in 2.8.2 isUsed -->
                <xsl:if test="../isUsed = false()">
                  <xsl:element name="isUsed">
                    <xsl:choose>
                      <xsl:when test=". != '0'">ST_YES</xsl:when>
                      <xsl:otherwise>ST_NO</xsl:otherwise>
                    </xsl:choose>
                  </xsl:element>
                </xsl:if>
              </xsl:when>
              <xsl:when test="name()!='messageFilter'">
                <xsl:apply-templates select="."/>
              </xsl:when>
            </xsl:choose>
          </xsl:for-each>
          <xsl:if test="CAN_PARAM = false() and ETHERNET_PARAM = false()">
            <xsl:call-template name="AddCANParam"/>
          </xsl:if>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- NODE is extended  by subnetMask and gateway -->
  <!-- NODE it was extended by displayNetworkStates in previous version -->
  <!-- the most save way for conversion is to rewrite NOTE in the structure of the latest schema using the existing values -->
  <xsl:template match="NODE">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="NODE">
      <xsl:apply-templates select="netLocalCRC"/>
      <xsl:apply-templates select="netGroup"/>
      <xsl:apply-templates select="netNode"/>
      <xsl:apply-templates select="rsn"/>
      <xsl:apply-templates select="nodeType"/>
      <xsl:apply-templates select="scope"/>
      <xsl:element name="displayNetworkStates">
        <xsl:choose>
          <xsl:when test="displayNetworkStates = false() or displayNetworkStates = ''">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="displayNetworkStates"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:apply-templates select="label"/>
      <xsl:apply-templates select="ipAddress"/>
      <xsl:apply-templates select="subnetMask"/>
      <xsl:apply-templates select="gateway"/>
      <xsl:element name="multicastAddress">
        <xsl:if test="multicastAddress = true()">
          <xsl:value-of select="multicastAddress"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="portNumber">
        <xsl:choose>
          <xsl:when test="portNumber = true() and portNumber != ''">
            <xsl:value-of select="portNumber"/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <!-- new in 2.8.2 -->
      <xsl:element name="useEthernetSettings">
        <xsl:choose>
          <xsl:when test="useEthernetSettings = false() or useEthernetSettings = ''">
            <xsl:choose>
              <xsl:when test="ipAddress != ''">
                <xsl:text>ST_YES</xsl:text>
              </xsl:when>
              <xsl:otherwise>ST_NO</xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="useEthernetSettings"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="syncRequired">
        <xsl:choose>
          <xsl:when test="syncRequired = false() or syncRequired = ''">
            <xsl:choose>
              <xsl:when test="scope = 'NETWORK' and descendant::FBF = true()">
                <xsl:text>ST_YES</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>ST_NO</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="syncRequired"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <!--  change in 2.13.1 -->
      <xsl:choose>
        <xsl:when test="assignedCMServer = true()">
			<!-- the variable "temp" will not be used; it is only needed to call the function SetCurrentAssignedCMServer-->
			<xsl:variable name="temp" select="user:SetCurrentAssignedCMServer(string(assignedCMServer))"/>
        </xsl:when>
        <xsl:otherwise>
			<!-- the variable "temp" will not be used; it is only needed to call the function SetCurrentAssignedCMServer-->
			<xsl:variable name="temp" select="user:SetCurrentAssignedCMServer('0')"/>
        </xsl:otherwise>
      </xsl:choose>
      <!--  new in 2.9.2 -->
      <xsl:choose>
        <xsl:when test="showEthernetRxOverloadWarning = false()">
        <xsl:element name="showEthernetRxOverloadWarning">ST_YES</xsl:element>
        </xsl:when>
        <xsl:otherwise>
        <xsl:apply-templates select="showEthernetRxOverloadWarning"/>
        </xsl:otherwise>
      </xsl:choose>
      <!--  new in 2.9.1 -->
      <xsl:choose>
        <xsl:when test="usePanelNetworkingOverIP = false()">
        <xsl:element name="usePanelNetworkingOverIP">ST_YES</xsl:element>
        </xsl:when>
        <xsl:otherwise>
        <xsl:apply-templates select="usePanelNetworkingOverIP"/>
        </xsl:otherwise>
      </xsl:choose>
        
      <!-- <xsl:if test="nodeType = 'FPA5000' or nodeType = 'FPA1200_EN' or nodeType = 'FPA5000_RK'"> -->
      <xsl:if test="user:IsServer(string(nodeType)) = false()">
        <xsl:element name="SPANNING_TREE">
          <xsl:choose>
            <xsl:when test="SPANNING_TREE = true()">
              <xsl:apply-templates select="SPANNING_TREE"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="InsertSPANNING_TREE"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
        <xsl:element name="NET_INTERFACES">
          <xsl:apply-templates select="NET_INTERFACES"/>
        </xsl:element>
        <xsl:element name="EXPORTS">
          <xsl:apply-templates select="EXPORTS/*"/>
        </xsl:element>
        <xsl:element name="IMPORTS">
          <xsl:apply-templates select="IMPORTS/*"/>
        </xsl:element>
        <xsl:element name="ASSIGNED_OPCSVRS">
          <xsl:apply-templates select="ASSIGNED_OPCSVRS/*"/>
        </xsl:element>
      </xsl:if>
      <!--      <xsl:if test="nodeType = 'FPA5000' or nodeType = 'FPA1200_EN' or nodeType = 'FPA5000_RK'"> -->
      <xsl:if test="user:IsServer(string(nodeType)) = false()">
        <xsl:element name="ASSIGNED_MTS_NODES">
          <xsl:apply-templates select="ASSIGNED_MTS_NODES/*"/>
        </xsl:element>
      </xsl:if>
      <!-- for Remote Keypad only -->
      <xsl:if test="user:IsRemoteKeypad(string(nodeType)) = true()">
        <xsl:element name="CONNECTABLE">
          <xsl:apply-templates select="CONNECTABLE/*"/>
        </xsl:element>
      </xsl:if>
      <!--    <xsl:if test="nodeType = 'FPA5000' or nodeType = 'FPA1200_EN' or nodeType = 'FPA5000_RK'"> -->
      <xsl:if test="user:IsServer(string(nodeType)) = false()">
        <xsl:element name="CONFIG_DATA">
          <xsl:apply-templates select="CONFIG_DATA/*"/>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- For existing SPANNING_TREE -->
  <xsl:template match="SPANNING_TREE">
    <xsl:apply-templates select="*"/>
  </xsl:template>
  <!--  extend NET_INTERFACES by ETHERNET -->
  <xsl:template match="NET_INTERFACES">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:for-each select="*">
      <xsl:apply-templates select="."/>
    </xsl:for-each>
    <xsl:if test="NET_INTERFACE/ETHERNET_PARAM = false()">
      <xsl:call-template name="CreateEthernetInterface">
        <xsl:with-param name="InterfaceNumber" select="'1'"/>
      </xsl:call-template>
      <!-- creation due to an update can only be on an FPA_5000-B with one ethernet-interface
      <xsl:call-template name="CreateEthernetInterface">
        <xsl:with-param name="InterfaceNumber" select="'4'"/>
      </xsl:call-template>
       -->
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="ETHERNET_PARAM">
    <xsl:element name="ETHERNET_PARAM">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="STP_PathCost = false()">
        <xsl:element name="STP_PathCost">200000</xsl:element>
        <xsl:element name="STP_PortPriority">128</xsl:element>
        <xsl:element name="RSTP_LinkType">AUTO</xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!--  copy explicitly attribute panelEncoding -->
  <xsl:template match="LOCAL_CONFIGURATION">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="LOCAL_CONFIGURATION">
      <xsl:attribute name="panelEncoding"><xsl:choose><xsl:when test="@panelEncoding = ''"><xsl:text>ISO-8859-1</xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="@panelEncoding"/></xsl:otherwise></xsl:choose></xsl:attribute>
      <xsl:apply-templates select="*"/>
    </xsl:element>
  </xsl:template>
  <!-- RULE and RULE_STATE: note must be added -->
  <xsl:template match="RULE | RULE_STATE">
    <xsl:element name="{name()}">
      <xsl:if test="note = false()">
        <xsl:element name="note"/>
      </xsl:if>
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- make existing RULE_STATE sequence to one RULE_STATE_BLOCK -->
  <xsl:template match="RULE_STATE">
    <xsl:choose>
      <xsl:when test="parent::RULE_STATE_BLOCK = false()">
        <xsl:if test="preceding-sibling::RULE_STATE = false()">
          <xsl:element name="RULE_STATE_BLOCK">
            <xsl:for-each select="../RULE_STATE">
              <xsl:element name="RULE_STATE">
                <xsl:apply-templates/>
              </xsl:element>
            </xsl:for-each>
          </xsl:element>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select=".">
          <xsl:element name="RULE_STATE">
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- SET 32 RULES -->
  <xsl:template match="TRIGGER_USER">
    <xsl:choose>
      <xsl:when test="ancestor::SET/siType = 'MP_SI_OUTPUT_GROUP' and ancestor::SET/siNumber = '32' and command = 'MP_CMD_LOGIN' and userId = '9'">
        <xsl:element name="TRIGGER_COUNTER">
          <xsl:element name="triggerSubject">COUNTER</xsl:element>
          <xsl:element name="triggerNumber">OPERATOR9_SCOPE</xsl:element>
          <xsl:element name="threshold">0</xsl:element>
          <xsl:element name="condition">GT</xsl:element>
        </xsl:element>
      </xsl:when>
      <xsl:when test="ancestor::SET/siType = 'MP_SI_OUTPUT_GROUP' and ancestor::SET/siNumber = '32' and command = 'MP_CMD_LOGOFF' and userId = '9'">
        <xsl:element name="TRIGGER_COUNTER">
          <xsl:element name="triggerSubject">COUNTER</xsl:element>
          <xsl:element name="triggerNumber">OPERATOR9_SCOPE</xsl:element>
          <xsl:element name="threshold">0</xsl:element>
          <xsl:element name="condition">LT_EQ</xsl:element>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="TRIGGER_USER">
          <xsl:apply-templates select="*"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- #################  CHANGES for 2.1.0 ########################### -->
  <!-- INPUT revision and extension -->
  <xsl:template match="INPUT">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="INPUT">
      <xsl:element name="siType">
        <xsl:value-of select="siType"/>
      </xsl:element>
      <xsl:element name="port">
        <xsl:choose>
          <xsl:when test="name(..) = 'NTK100'">
            <xsl:text>9</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="port"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="subNumber">
        <xsl:value-of select="subNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:element name="bypassable">
        <xsl:value-of select="bypassable"/>
      </xsl:element>
      <xsl:element name="blockable">
        <xsl:value-of select="blockable"/>
      </xsl:element>
      <xsl:element name="usageType">
        <xsl:value-of select="usageType"/>
      </xsl:element>
      <xsl:element name="dayNightMode">
        <xsl:value-of select="dayNightMode"/>
      </xsl:element>
      <xsl:element name="andDetector">
        <xsl:choose>
          <xsl:when test="andDetector = false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="andDetector"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="andZoneNr">
        <xsl:choose>
          <xsl:when test="andZoneNr = false()">
            <xsl:text>0</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="andZoneNr"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="andLatching">
        <xsl:choose>
          <xsl:when test="andLatching = false()">
            <xsl:text>ST_NO</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="andLatching"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="resetOutput">
        <xsl:choose>
          <xsl:when test="resetOutput = false()">
            <xsl:text>0.0.0.0</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="resetOutput"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="resetTime">
        <xsl:choose>
          <xsl:when test="resetTime = false()">
            <xsl:text>0</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="resetTime"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:if test="name(..) = 'LSNI_IN2' or name(..) = 'LSNI_IN2_D' or name(..) = 'LSNI_IN8R1' or name(..) = 'LSNI_IN1' or name(..) = 'LSNI_OUT8_IN2' or name(..) = 'LSNI_OUT1_IN1'">
        <xsl:element name="operatingMode">
          <xsl:choose>
            <xsl:when test="operatingMode = false()">
              <xsl:text>RESISTANCE</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="operatingMode"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
        <xsl:element name="invertActivation">
          <xsl:choose>
            <xsl:when test="invertActivation = false()">
              <xsl:text>ST_NO</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="invertActivation"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
        <xsl:element name="thresholdHigh">
          <xsl:choose>
            <xsl:when test="thresholdHigh = false()">
              <xsl:text>VOLTAGE_3</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="thresholdHigh"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
        <xsl:element name="thresholdLow">
          <xsl:choose>
            <xsl:when test="thresholdLow = false()">
              <xsl:text>VOLTAGE_1</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="thresholdLow"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
        <xsl:element name="usesEOLResistor">
          <xsl:choose>
            <xsl:when test="usesEOLResistor = false()">
              <xsl:text>ST_NO</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="usesEOLResistor"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:if>
  <!-- version 2.8.4: INPUTs under ONBOARD and INPUTs under IO_8_MODULE will be extended by inverted -->
      <xsl:choose>
        <xsl:when test="name(../.) = 'IO_8_MODULE'">
			<xsl:choose>
				<xsl:when test="activeIfClosed = false()">
				    <xsl:element name="activeIfClosed">ST_YES</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="activeIfClosed"><xsl:value-of select="activeIfClosed"/></xsl:element>
				</xsl:otherwise>
			</xsl:choose>
        </xsl:when>
        <xsl:when test="name(../.) = 'OB_INPUTS'">
			<xsl:choose>
				<xsl:when test="activeIfClosed = false()">
				    <xsl:element name="activeIfClosed">ST_NO</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="activeIfClosed"><xsl:value-of select="activeIfClosed"/></xsl:element>
				</xsl:otherwise>
			</xsl:choose>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- RELAY revision and extension, write RELAYS with the new order and and insert subType for any RELAY-->
  <xsl:template match="RELAY">
    <xsl:element name="{name()}">
      <xsl:choose>
        <xsl:when test="parent::LSNI_RLE = true()">
          <!--  LSNI_RLE was introduced newly in 2.1.0 and must not be converted or sorted -->
          <xsl:apply-templates select="*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="siType">
            <xsl:value-of select="siType"/>
          </xsl:element>
          <xsl:element name="port">
            <xsl:value-of select="port"/>
          </xsl:element>
          <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
          </xsl:element>
          <xsl:element name="subNumber">
            <xsl:value-of select="subNumber"/>
          </xsl:element>
          <xsl:element name="label">
            <xsl:value-of select="label"/>
          </xsl:element>
          <xsl:element name="subType">
            <xsl:choose>
              <xsl:when test="subType = false()">
                <xsl:choose>
                  <xsl:when test="siType = 'MP_SI_FIREEXTINGUISHER'">
                    <xsl:text>MP_ST_FIREEX_VDS</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>MP_ST_NONE</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="subType"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:element>
          <xsl:element name="nacType">
            <xsl:value-of select="nacType"/>
          </xsl:element>
          <xsl:element name="bypassable">
            <xsl:value-of select="bypassable"/>
          </xsl:element>
          <xsl:element name="blockable">
            <xsl:value-of select="blockable"/>
          </xsl:element>
          <xsl:element name="silenceable">
            <xsl:value-of select="silenceable"/>
          </xsl:element>
          <xsl:element name="drillable">
            <xsl:value-of select="drillable"/>
          </xsl:element>
          <xsl:element name="restPosition">
            <xsl:value-of select="restPosition"/>
          </xsl:element>
          <xsl:element name="supervised">
            <xsl:value-of select="supervised"/>
          </xsl:element>
          <xsl:if test="feedbackVariant = true()">
            <xsl:element name="feedbackVariant">
              <xsl:value-of select="feedbackVariant"/>
            </xsl:element>
          </xsl:if>
          <xsl:if test="feedback = true()">
            <xsl:element name="feedback">
              <xsl:value-of select="feedback"/>
            </xsl:element>
          </xsl:if>
          <xsl:if test="feedbackDelay = true()">
            <xsl:element name="feedbackDelay">
              <xsl:value-of select="feedbackDelay"/>
            </xsl:element>
          </xsl:if>
          <xsl:if test="fault = true()">
            <xsl:element name="fault">
              <xsl:value-of select="fault"/>
            </xsl:element>
          </xsl:if>
          <xsl:if test="feedbackEOL = true()">
            <xsl:element name="feedbackEOL">
              <xsl:value-of select="feedbackEOL"/>
            </xsl:element>
          </xsl:if>
          <xsl:if test="feedbackActivation = true()">
            <xsl:element name="feedbackActivation">
              <xsl:value-of select="feedbackActivation"/>
            </xsl:element>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- LSNRELAY revision and extension, write RELAYS with the new order and and insert subType for any RELAY-->
  <!-- The new element independentInput must be added, the value of it is calculated by looking at the value of feedbackVariant: 
         'F0' stood for no-feedback, this cannot be used any more because independent inputs need values for the resistor setting
          'F1' to 'F12' even if they no feedback is used. -->
  <xsl:template match=" LSNRELAY">
    <xsl:element name="{name()}">
      <xsl:element name="siType">
        <xsl:value-of select="siType"/>
      </xsl:element>
      <xsl:element name="port">
        <xsl:value-of select="port"/>
      </xsl:element>
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="subNumber">
        <xsl:value-of select="subNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:element name="subType">
        <xsl:choose>
          <xsl:when test="subType = false()">
            <xsl:text>MP_ST_NONE</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="subType"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="nacType">
        <xsl:value-of select="nacType"/>
      </xsl:element>
      <xsl:element name="bypassable">
        <xsl:value-of select="bypassable"/>
      </xsl:element>
      <xsl:element name="blockable">
        <xsl:value-of select="blockable"/>
      </xsl:element>
      <xsl:element name="silenceable">
        <xsl:value-of select="silenceable"/>
      </xsl:element>
      <xsl:element name="drillable">
        <xsl:value-of select="drillable"/>
      </xsl:element>
      <xsl:element name="restPosition">
        <xsl:value-of select="restPosition"/>
      </xsl:element>
      <xsl:element name="supervised">
        <xsl:value-of select="supervised"/>
      </xsl:element>
      <xsl:if test="feedbackVariant = true()">
        <xsl:element name="feedbackVariant">
          <xsl:choose>
            <!-- F0 stood for  no feedback used, it is no longer valid and must be set to the default = F1 -->
            <xsl:when test="feedbackVariant = 'F0'">
              <xsl:text>F1</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="feedbackVariant"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:if>
      <xsl:if test="feedback = true()">
        <xsl:element name="feedback">
          <xsl:value-of select="feedback"/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="feedbackDelay = true()">
        <xsl:element name="feedbackDelay">
          <xsl:value-of select="feedbackDelay"/>
        </xsl:element>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="independentInput = true()">
          <xsl:element name="independentInput">
            <xsl:value-of select="independentInput"/>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="independentInput">
            <xsl:choose>
              <!-- if no feedback used, the line is used as independent input -->
              <xsl:when test="feedbackVariant = 'F0'">
                <xsl:text>ST_YES</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>ST_NO</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!--  copy the RLHVI node with all childrens by applying templates ( template LSNRELAY obove must be performed) 
          add INPUT nodes if needed -->
  <xsl:template match="RLHVI">
    <xsl:element name="RLHVI">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'LSNRELAY'">
            <xsl:apply-templates select="."/>
            <!-- INPUTS are first allowed as children of RLHV from schema 2.1.0 on -->
            <xsl:if test="INPUT = false()">
              <!-- if the first LSNRELAY is not used was feedback we need an additional node INPUT (siNumber is set th zero like done by RPS) -->
              <xsl:if test="LSNRELAY[1]/feedbackVariant = 'F0'">
                <xsl:call-template name="AddINPUT">
                  <xsl:with-param name="PortNbr" select="number(LSNRELAY[1]/port) + 2"/>
                </xsl:call-template>
              </xsl:if>
              <!-- if the second LSNRELAY is not used was feedback we need an additional node INPUT (siNumber is set th zero like done by RPS) -->
              <xsl:if test="LSNRELAY[2]/feedbackVariant = 'F0'">
                <xsl:call-template name="AddINPUT">
                  <xsl:with-param name="PortNbr" select="number(LSNRELAY[2]/port) + 2"/>
                </xsl:call-template>
              </xsl:if>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="MSS400 | MSS401">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="drillPattern = false()">
        <xsl:element name="drillPattern">
          <xsl:text>MP_ACM_CONTINOUS</xsl:text>
        </xsl:element>
      </xsl:if>
      <xsl:if test="drillVolume = false()">
        <xsl:element name="drillVolume">
          <xsl:text>4</xsl:text>
        </xsl:element>
      </xsl:if>
      <xsl:if test="testActivationPattern = false()">
        <xsl:element name="testActivationPattern">
          <xsl:text>MP_ACM_CONTINOUS</xsl:text>
        </xsl:element>
      </xsl:if>
      <xsl:if test="testActivationVolume = false()">
        <xsl:element name="testActivationVolume">
          <xsl:text>4</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="NAC_ZONE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="drillPattern = false()">
        <xsl:element name="drillPattern">
          <xsl:text>MP_ACM_CONTINOUS</xsl:text>
        </xsl:element>
      </xsl:if>
      <xsl:if test="testActivationPattern = false()">
        <xsl:element name="testActivationPattern">
          <xsl:text>MP_ACM_CONTINOUS</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="NAC_ACTION">
    <xsl:element name="NAC_ACTION">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'duration'">
            <xsl:apply-templates select="."/>
            <xsl:if test="../volume = false()">
              <xsl:element name="volume">
                <xsl:variable name="SiNumber" select="ancestor::NAC_GROUP/siNumber"/>
                <xsl:variable name="SubNumber" select="ancestor::NAC/subNumber"/>
                <xsl:variable name="PhysNode" select="ancestor::NODE/descendant::MSS400|ancestor::NODE/descendant::MSS401"/>
                <xsl:if test="user:ResetMax()"/>
                <xsl:for-each select="$PhysNode[siNumber = $SiNumber]">
                  <xsl:if test="user:SetMax(number(volume))"/>
                </xsl:for-each>
                <xsl:value-of select="user:GetMax()"/>
              </xsl:element>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- EN 54-2 sum of PANEL/PASacknowledge and GROUP/investigationTime must not be greater 10 minutes-->
  <xsl:template match="GROUP/investigationTime">
    <xsl:element name="investigationTime">
      <xsl:variable name="SumTime" select="number(ancestor::PANEL/PASacknowledge) + number(.) * 60"/>
      <xsl:choose>
        <xsl:when test="$SumTime &gt; 600">
          <xsl:variable name="ToMuch" select="$SumTime - 600"/>
          <xsl:value-of select="floor(number(.) - $ToMuch div 60)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- EN 54-2 minimum of PANEL/andDelay is 300 -->
  <xsl:template match="PANEL/andDelay">
    <xsl:element name="andDelay">
      <xsl:choose>
        <xsl:when test="number(.) &lt; 300">
          <xsl:text>300</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="TRANSFER/maxPipeBytepoolSize">
    <xsl:element name="maxPipeBytepoolSize">
      <xsl:text>8192</xsl:text>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="NETWORK_INFO">
    <xsl:element name="NETWORK_INFO">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="bypassNACsRange = false()">
        <xsl:element name="bypassNACsRange">
          <xsl:text>BPR_ALL</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!-- -->
  <xsl:template match="ACTIVITYTEXTS">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="info_alarm = false()">
        <xsl:element name="info_alarm">
          <xsl:text>

</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- new in 2.5.1 for EN54-13 -->
  <!-- Add en5413Enaled as last element to GLTZONE if not already there -->
  <xsl:template match="GLTZONE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="en5413Enabled = false()">
        <xsl:element name="en5413Enabled">
          <xsl:text>ST_NO</xsl:text>
        </xsl:element>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- Extend LSN-Modules -->
  <xsl:template match="LSN1500_MODULE | LSN300_MODULE">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
        <xsl:choose>
          <xsl:when test="name(.) = 'creepingShortDetectionOff' and following-sibling::en5413Enabled = false()">
            <!-- not yet en4513Enabled -->
            <xsl:element name="en5413Enabled">ST_NO</xsl:element>
            <xsl:element name="detect4wShort">ST_NO</xsl:element>
            <xsl:element name="aux1CreepI_max">0</xsl:element>
            <xsl:element name="aux2CreepI_max">0</xsl:element>
          </xsl:when>
          <xsl:when test="name(.) = 'en5413Enabled' and following-sibling::detect4wShort = false()">
            <!-- not yet detect4wShort -->
            <xsl:element name="detect4wShort">ST_NO</xsl:element>
            <xsl:element name="aux1CreepI_max">0</xsl:element>
            <xsl:element name="aux2CreepI_max">0</xsl:element>
          </xsl:when>
          <xsl:when test="name(.) = 'detect4wShort' and following-sibling::aux1CreepI_max = false()">
            <!-- not yet aux1CreepI_max -->
            <xsl:element name="aux1CreepI_max">0</xsl:element>
            <xsl:element name="aux2CreepI_max">0</xsl:element>
          </xsl:when>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- Add en5413Enabled after  nrOfDetectors  if not already there -->
  <xsl:template match="GLTZONE_LSNI_CONV4">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
        <xsl:if test="name(.) = 'nrOfDetectors' and following-sibling::en5413Enabled != true()">
          <xsl:element name="en5413Enabled">ST_NO</xsl:element>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template match="GLTZONE_LSNI_CONV4" mode="InLSNNode">
	<xsl:call-template name="InsertConversionCommentWithMode">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
		<xsl:with-param name="myMode">InLSNNode</xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
        <xsl:if test="name(.) = 'nrOfDetectors' and following-sibling::en5413Enabled != true()">
          <xsl:element name="en5413Enabled">ST_NO</xsl:element>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- In 2.1.1 convert MP_ET_NORMAL_DAY to MP_ET_NORMAL, MP_ET_NORMAL_DAY supported again in 2.8.2 -->
  <!-- In 2.5.1 convert MP_ET_ALARM_DAY to MP_ET_FIRE_DAY -->
  <!-- In 2.5.1 convert MP_ET_ALARM_WALKTEST to MP_ET_FIRE_WALKTEST -->
  <xsl:template match="COUNTER/cstate |  TRIGGER_STATE/oldstate | TRIGGER_STATE/newstate  | CONDITION_STATE/compoundState">
    <xsl:element name="{name()}">
      <xsl:choose>
        <!-- no more for 2.8.2
        <xsl:when test=". = 'MP_ET_NORMAL_DAY'">
          <xsl:text>MP_ET_NORMAL</xsl:text>
        </xsl:when>
-->
        <xsl:when test=". = 'MP_ET_ALARM_DAY'">
          <xsl:text>MP_ET_FIRE_DAY</xsl:text>
        </xsl:when>
        <xsl:when test=". = 'MP_ET_ALARM_WALKTEST'">
          <xsl:text>MP_ET_FIRE_WALKTEST</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- CONVERSION of NEW LSN-Structure BEGIN -->
  <!-- 	this template specializes the generic match=* - template. It is called for all elements of an LSN-device-node and behaves like match=* without a mode with one exception:
			LSN-elements which are in the list of t-table devices shall not be written, what is performed by a specialized template  with mode -->
  <xsl:template match="*" mode="InLSNNode">
	<xsl:call-template name="InsertConversionCommentWithMode">
		<xsl:with-param name="structureName"><xsl:text>match all</xsl:text></xsl:with-param>
		<xsl:with-param name="myMode">InLSNNode</xsl:with-param>
	</xsl:call-template> 
    <xsl:choose>
      <xsl:when test="name(../.) = 'DM210' or name(../.) = 'NBM110' or name(../.) = 'PULLSTATION'">
        <xsl:call-template name="PatchManualCallPoints"/>
      </xsl:when>
      <xsl:when test="name(../.) = 'LSN_NAC'">
        <xsl:call-template name="PatchLSN_NAC"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name()}">
          <xsl:apply-templates select="@* | node()"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- template for all LSN-device-nodes which can be used with T-tapping shall not be written if found inside other LSN-device-nodes -->
  <xsl:template match="DM210 | PULLSTATION | T220IUS | T410I | O220IUS | OT220IUS | OTC220IUS | O500IUS |  OC500IUS | O500I | O410I | OC410I | OT410I | OTC410I | LSN_NAC | RLHVI | OC500I | ISOLATOR | LSNI_OUT2 | LSNI_OUT2_D | LSNI_IN2 | LSNI_IN2_D | LSNI_RELAY1 | LSNI_RELAY1_D | RAS_TPS1 | RAS_TPS2 | RAS_TTS1 | RAS_TTS2 | RAS_TMS | RAS_TMS_NOFAN | RAS_TMS_RB | LSNI_CONV4 | LSNI_RELAY8 | LSNI_BEACON | LSNI_IN8R1 | LSNI_OUT8_IN2 | LSNI_IN1 | LSNI_OUT1_IN1 | LSNI_RLE | FULLEON_BASE | FULLEON_STANDALONE| FULLEON_BASE_U | FULLEON_STANDALONE_U | KD55_KD200 | LSNI_EOL_2W | LSNI_EOL_4W | DO410I | DOT410I  | DOTC410I" mode="InLSNNode">
	<xsl:call-template name="InsertConversionCommentWithMode">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
		<xsl:with-param name="myMode">InLSNNode</xsl:with-param>
	</xsl:call-template> 
    <xsl:variable name="EName" select="name()"/>
    <xsl:variable name="COMAdr" select="comAdr"/>
    <xsl:comment>
      <xsl:text>element moved: name = </xsl:text>
      <xsl:value-of select="$EName"/>
      <xsl:text>, comAdr = </xsl:text>
      <xsl:value-of select="$COMAdr"/>
    </xsl:comment>
  </xsl:template>
  <!-- normal handling of LSN-device-nodes -->
  <xsl:template match="DOW1171 | ATX100 | O500 | OC500 | FBF100 | FK100 | MSS400 | MSS401 | NAK100 | NBK100 | NBM110 | NEV300 | NIM100 | NKK100 | NOM100 | NSB100 | NTK100 | NTM100 | O410 | OC410 | OM200 | OT200 | OT410 | OTC410 | T410 | TM200 | DM210 | PULLSTATION | T220IUS | T410I | O220IUS | OT220IUS | OTC220IUS | O500IUS |  OC500IUS | O500I | O410I | OC410I | OT410I | OTC410I | LSN_NAC | RLHVI | OC500I | ISOLATOR | LSNI_OUT2 | LSNI_OUT2_D | LSNI_IN2 | LSNI_IN2_D | LSNI_RELAY1 | LSNI_RELAY1_D | RAS_TPS1 | RAS_TPS2 | RAS_TTS1 | RAS_TTS2 | RAS_TMS | RAS_TMS_NOFAN | RAS_TMS_RB | LSNI_CONV4 | LSNI_RELAY8 | LSNI_BEACON | LSNI_IN8R1 | LSNI_OUT8_IN2 | LSNI_IN1 | LSNI_OUT1_IN1 | LSNI_RLE | FULLEON_BASE | FULLEON_STANDALONE | FULLEON_BASE_U | FULLEON_STANDALONE_U  | KD55_KD200 | LSNI_EOL_2W | LSNI_EOL_4W | DO410I | DOT410I  | DOTC410I">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:variable name="ElementName" select="name()"/>
    <xsl:choose>
      <xsl:when test="backPointer = false()">
        <!-- Convert to new LSN-structure -->
        <xsl:element name="{name()}">
          <xsl:variable name="BackPointer">
            <xsl:choose>
              <!-- if ttapping backPointer is comAdr of parent -->
              <xsl:when test="ancestor::LSN300_MODULE/mode = 'LSN_TTAP' or ancestor::LSN1500_MODULE/mode = 'LSN_TTAP'">
                <xsl:choose>
                  <xsl:when test="../comAdr">
                    <xsl:value-of select="../comAdr"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <!-- if the first element is under  a second LS_BUS, its a stub and the backpointer must be 255-->
                      <xsl:when test="ancestor::LSN_BUS/port = '2'">255</xsl:when>
                      <xsl:otherwise>0</xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <!-- if NOTttapping backPointer is comAdr of last preceding-sibling -->
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="preceding-sibling::*/comAdr">
                    <xsl:value-of select="preceding-sibling::*[1]/comAdr"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test="../../LSN_BUS_NAK100 = true() or ../../LSN_BUS_FK100 = true()">
                        <xsl:value-of select="../../comAdr"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:choose>
                          <!-- if the first element is under  a second LS_BUS, its a stub and the backpointer must be 255-->
                          <xsl:when test="ancestor::LSN_BUS/port = '2'">255</xsl:when>
                          <xsl:otherwise>0</xsl:otherwise>
                        </xsl:choose>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:element name="lsnTypeID">
            <xsl:variable name="Condition" select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName]/@condition"/>
            <xsl:choose>
              <xsl:when test="descendant::siType = $Condition">
                <xsl:value-of select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName and @condition = $Condition]/lsnTypeID"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName]/lsnTypeID"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:element>
          <xsl:element name="lsnSubtype">
            <xsl:value-of select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName]/lsnSubtype"/>
          </xsl:element>
          <xsl:element name="backPointer">
            <xsl:value-of select="$BackPointer"/>
          </xsl:element>
          <xsl:choose>
            <xsl:when test="$ElementName = 'NAK100'">
              <xsl:element name="branch">
				 <xsl:choose>
						<xsl:when test="LSN_BUS_NAK100/*[1]=true()">
							<xsl:value-of select="LSN_BUS_NAK100/*[1]/comAdr"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
              </xsl:element>
            </xsl:when>
            <xsl:when test="$ElementName = 'FK100'">
              <xsl:element name="branch">
                <xsl:value-of select="LSN_BUS_FK100/*[1]/comAdr"/>
              </xsl:element>
            </xsl:when>
          </xsl:choose>
          <!-- now write the rest of the existing elements but not the indented T-Tap-elements by applying special mode template where the indented t-tap nodes are skipped -->
          <xsl:for-each select="*">
            <xsl:apply-templates select="." mode="InLSNNode"/>
          </xsl:for-each>
        </xsl:element>
        <!-- now write an indented LSN-device-node which was found inside the LSN-device-node because of being t-tappable -->
        <xsl:for-each select="DM210 | PULLSTATION | T220IUS | T410I | O220IUS | OT220IUS | OTC220IUS | O500IUS |  OC500IUS | O500I | O410I | OC410I | OT410I | OTC410I | LSN_NAC | RLHVI | OC500I | ISOLATOR | LSNI_OUT2 | LSNI_OUT2_D | LSNI_IN2 | LSNI_IN2_D | LSNI_RELAY1 | LSNI_RELAY1_D | RAS_TPS1 | RAS_TPS2 | RAS_TTS1 | RAS_TTS2 | RAS_TMS | RAS_TMS_NOFAN | RAS_TMS_RB | LSNI_CONV4 | LSNI_RELAY8 | LSNI_BEACON | LSNI_IN8R1 | LSNI_OUT8_IN2 | LSNI_IN1 | LSNI_OUT1_IN1 | LSNI_RLE | FULLEON_BASE | FULLEON_STANDALONE | FULLEON_BASE_U | FULLEON_STANDALONE_U | KD55_KD200 | LSNI_EOL_2W | DO410I | DOT410I  | DOTC410I">
          <!-- note: this is a recursive call to the template we are in -->
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <!-- already converted to new LSN-structure -->
        <xsl:element name="{name()}">
          <xsl:for-each select="*">
            <xsl:choose>
              <xsl:when test="name(../.) = 'DM210' or name(../.) = 'NBM110' or name(../.) = 'PULLSTATION'">
                <xsl:call-template name="PatchManualCallPoints"/>
              </xsl:when>
              <xsl:when test="name(../.) = 'LSN_NAC'">
                <xsl:call-template name="PatchLSN_NAC"/>
              </xsl:when>
              <xsl:when test="name(../.) = 'FULLEON_BASE_U' or name(../.) = 'FULLEON_STANDALONE_U'">
                <xsl:call-template name="PatchFULLEON_U"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="."/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- patches to LSNElements have to be made simular to this template, a template matching any LSN-device name cannot  be used, since it is already used for converting
          the old LSN-structure to the new one -->
  <!-- insert elements added in schema version 2.7.1  -->
  <xsl:template name="PatchManualCallPoints">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()"/>
    </xsl:element>
    <xsl:if test="name() = 'dayNightMode'">
      <!-- not already extended -->
      <xsl:if test="../av = false()">
        <xsl:element name="av">ST_NO</xsl:element>
        <xsl:element name="avDelay">0</xsl:element>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <!--  insert element added in schema version 2.7.1 -->
  <xsl:template name="PatchLSN_NAC">
      <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()"/>
    </xsl:element>
    <xsl:if test="name() = 'standbyLEDblinking'">
      <!-- not already extended -->
      <xsl:if test="../actualCurrent = false()">
        <xsl:element name="actualCurrent">0</xsl:element>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <!--  insert batteryUsed as last element of FULLEON_.._U    -->
  <xsl:template name="PatchFULLEON_U">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()"/>
    </xsl:element>
    <xsl:if test="name() = 'testActivationVolume'">
      <!-- not already extended -->
      <xsl:if test="../batteryUsed = false()">
        <xsl:element name="batteryUsed">ST_YES</xsl:element>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <!-- CONVERSION of NEW LSN-Structure END -->
  <!--   Refactor AUXPOWER   -->
  <xsl:template match="AUXPOWER" mode="InLSNNode">
	<xsl:call-template name="InsertConversionCommentWithMode">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
		<xsl:with-param name="myMode">InLSNNode</xsl:with-param>
	</xsl:call-template> 
	  <xsl:call-template name="CorrectAUXPOWER"/>
  </xsl:template>
  <xsl:template match="AUXPOWER">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
	  <xsl:call-template name="CorrectAUXPOWER"/>
  </xsl:template>
  <xsl:template name="CorrectAUXPOWER">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'batteryBackup'">
            <xsl:if test="name(../../.) = 'BATTERY_CONTR_MODULE'">
              <xsl:apply-templates select="."/>
            </xsl:if>
            <xsl:if test="name(../../.) != 'BATTERY_CONTR_MODULE'">
				<!-- delete batteryBackup-->
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
      <xsl:if test="LINE_SUPERVISION = false()">
        <xsl:if test="name(../.) = 'LSN1500_MODULE' or name(../.) = 'LSN300_MODULE' or name(../.) = 'BCMB_MODULE'">
          <xsl:element name="LINE_SUPERVISION">
            <xsl:element name="physAddrOfEOLDevice">0.0.0.0</xsl:element>
            <xsl:element name="isConventional">ST_NO</xsl:element>
          </xsl:element>
        </xsl:if>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!-- version 2.11.0: new function-type MP_FT_SYSTEMSTATUS -->
  <xsl:template match="FTYPE_LZ_MAPPINGS">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
		<xsl:for-each select="*">
			<xsl:apply-templates select="."/>
		</xsl:for-each>
		<xsl:call-template name="Insert_FT_SYSTEMSTATUS"/>
    </xsl:element>
  </xsl:template>
  <xsl:template name="Insert_FT_SYSTEMSTATUS">
	  <xsl:element name="FTYPE_LZ_MAPPING">
			<xsl:element name="functionType">MP_FT_SYSTEMSTATUS</xsl:element>
			<xsl:element name="CSTATES">
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_NORMAL</xsl:element>
					<xsl:element name="lz">24</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_TROUBLE</xsl:element>
					<xsl:element name="lz">27</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_ON</xsl:element>
					<xsl:element name="lz">25</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_NORMAL_BLOCKED</xsl:element>
					<xsl:element name="lz">31</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_TROUBLE_BLOCKED</xsl:element>
					<xsl:element name="lz">31</xsl:element>
				</xsl:element>
			</xsl:element>
	  </xsl:element>
  </xsl:template>
  <xsl:template name="Insert_New_States_FT_UNLOCKAPPLIANCE">
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_HEAT</xsl:element>
					<xsl:element name="lz">79</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_SUPERVISORY</xsl:element>
					<xsl:element name="lz">13</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_SMOKE</xsl:element>
					<xsl:element name="lz">78</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_WATER</xsl:element>
					<xsl:element name="lz">13</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_FIRE_INT</xsl:element>
					<xsl:element name="lz">14</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_SUPERVISORY_WALKTEST</xsl:element>
					<xsl:element name="lz">45</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_WATER_WALKTEST</xsl:element>
					<xsl:element name="lz">45</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_HEAT_WALKTEST</xsl:element>
					<xsl:element name="lz">76</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_SMOKE_WALKTEST</xsl:element>
					<xsl:element name="lz">75</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_WATER_DAY</xsl:element>
					<xsl:element name="lz">13</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_HEAT_DAY</xsl:element>
					<xsl:element name="lz">14</xsl:element>
				</xsl:element>
				<xsl:element name="CSTATE_MAPPING">
					<xsl:element name="compoundState">MP_ET_SMOKE_DAY</xsl:element>
					<xsl:element name="lz">14</xsl:element>
				</xsl:element>
  </xsl:template>
  <!-- version 2.11.0: new compound-state MP_ET_TROUBLE_LIGHT to be converted for MP_FT_MEMORY -->
  <xsl:template match="CSTATES">
	<xsl:call-template name="InsertConversionComment">
		<xsl:with-param name="structureName"><xsl:value-of select="name()"/></xsl:with-param>
	</xsl:call-template> 
    <xsl:element name="{name()}">
		<xsl:choose>
			<xsl:when test="../functionType = 'MP_FT_MEMORY' and (./CSTATE_MAPPING/compoundState='MP_ET_TROUBLE_LIGHT') = false()">
			<xsl:for-each select="*">
				<xsl:apply-templates select="."/>
				<xsl:if test="compoundState='MP_ET_TROUBLE'">
					<xsl:element name="CSTATE_MAPPING">
						<xsl:element name='compoundState'>MP_ET_TROUBLE_LIGHT</xsl:element>
						<xsl:element name='lz'>90</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
			</xsl:when>
			<xsl:when test="../functionType = 'MP_FT_STATUS' and (./CSTATE_MAPPING/compoundState='MP_ET_NORMAL_BYPASS') = false()">
			<!-- if one new state is missing it can be assumed that all new states are missing -->
			<xsl:for-each select="*">
				<xsl:apply-templates select="."/>
				<xsl:if test="compoundState='MP_ET_NORMAL'">
					<xsl:element name="CSTATE_MAPPING">
						<xsl:element name='compoundState'>MP_ET_NORMAL_BYPASS</xsl:element>
						<xsl:element name='lz'>29</xsl:element>
					</xsl:element>
					<xsl:element name="CSTATE_MAPPING">
						<xsl:element name='compoundState'>MP_ET_NORMAL_BLOCKED</xsl:element>
						<xsl:element name='lz'>31</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
			</xsl:when>
			<xsl:when test="../functionType = 'MP_FT_UNLOCKAPPLIANCE' and (./CSTATE_MAPPING/compoundState='MP_ET_HEAT') = false()">
			<!-- if one new state is missing it can be assumed that all new states are missing -->
			<xsl:for-each select="*">
				<xsl:apply-templates select="."/>
				<xsl:if test="compoundState='MP_ET_FIRE_DAY'">
					<xsl:call-template name="Insert_New_States_FT_UNLOCKAPPLIANCE"/>
				</xsl:if>
			</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="*"/>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:element>
  </xsl:template>
  <xsl:template match="PANEL_COMMUNICATION">
	<!-- the variable "temp" will not be used; it is only needed to call the function SetRemoteServicesInserted-->
	<xsl:variable name="temp" select="user:SetRemoteServicesInserted(string('false'))"/>
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'TRANSFER'">
			  <xsl:choose>
					<xsl:when test="isTeleservice='ST_YES' and useIPTeleservice = 'ST_YES'">
						<!-- delete old entry and make new entry for Remote services-->
						<xsl:if test="user:GetCurrentAssignedCMServer() = '0'">
							<xsl:call-template name="Create_RemoteServicesAll">
								<xsl:with-param name="useTeleserviceVal">ST_YES</xsl:with-param>
								<xsl:with-param name="isAutoAnswerEnabledVal"><xsl:value-of select="isAutoAnswerEnabled"/></xsl:with-param>
								<xsl:with-param name="useCMVal">ST_NO</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="user:GetCurrentAssignedCMServer() = '1'">
							<xsl:call-template name="Create_RemoteServicesAll">
								<xsl:with-param name="useTeleserviceVal">ST_YES</xsl:with-param>
								<xsl:with-param name="isAutoAnswerEnabledVal"><xsl:value-of select="isAutoAnswerEnabled"/></xsl:with-param>
								<xsl:with-param name="useCMVal">ST_YES</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="."/>
			</xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
		<!-- insert CM (now Remote monitoring) data if used-->
		<xsl:if test="ancestor::NODE/assignedCMServer = '1' and user:GetRemoteServicesInserted() ='false'">
			<xsl:call-template name="Create_RemoteServicesAll">
				<xsl:with-param name="useTeleserviceVal">ST_NO</xsl:with-param>
				<xsl:with-param name="isAutoAnswerEnabledVal">ST_NO</xsl:with-param>
				<xsl:with-param name="useCMVal">ST_YES</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	  
    </xsl:element>
  </xsl:template>
  <xsl:template match="REMOTE_SERVICES">
  <!-- only conversion from 2.13.1 -->
	   <xsl:choose>
			<xsl:when test="$ConvertedFrom='2.13.1'">
				  <xsl:call-template name="Create_RemoteServicesAll">
				  <xsl:with-param name="useTeleserviceVal"><xsl:value-of select="IP_Teleservice/isEnabled"></xsl:value-of></xsl:with-param>
				  <xsl:with-param name="isAutoAnswerEnabledVal"><xsl:value-of select="IP_Teleservice/isAutoAnswerEnabled"></xsl:value-of></xsl:with-param>
				  <xsl:with-param name="useCMVal"><xsl:value-of select="RemoteMonitoring/isEnabled"></xsl:value-of></xsl:with-param>
				  </xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="REMOTE_SERVICES">
					<xsl:apply-templates select="*"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
  </xsl:template>
  <xsl:template name="Create_RemoteServicesAll">
	  <xsl:param name="useTeleserviceVal"/>
	  <xsl:param name="isAutoAnswerEnabledVal"/>
	  <xsl:param name="useCMVal"/>
	  <xsl:element name="REMOTE_SERVICES">
			<!-- the variable "temp" will not be used; it is only needed to call the function SetRemoteServicesInserted-->
			<xsl:variable name="temp" select="user:SetRemoteServicesInserted(string('true'))"/>
		  <xsl:call-template name="CreateTeleservice">
				<xsl:with-param name="useTeleserviceVal"><xsl:value-of select="$useTeleserviceVal"/></xsl:with-param>
				<xsl:with-param name="isAutoAnswerEnabledVal"><xsl:value-of select="$isAutoAnswerEnabledVal"/></xsl:with-param>
		  </xsl:call-template>
		  <xsl:element name="REMOTE_MONITORING">
			  <xsl:element name="isEnabled"><xsl:value-of select="$useCMVal"/></xsl:element>
		  </xsl:element>
	  </xsl:element>
  </xsl:template>
  <xsl:template name="CreateTeleservice">
	  <xsl:param name="useTeleserviceVal"/>
	  <xsl:param name="isAutoAnswerEnabledVal"/>
	  <xsl:element name="IP_TELESERVICE">
		<xsl:element name="isAutoAnswerEnabled"><xsl:value-of select="$isAutoAnswerEnabledVal"/></xsl:element>
		<xsl:element name="isEnabled"><xsl:value-of select="$useTeleserviceVal"/></xsl:element>
	  </xsl:element>
  </xsl:template>
  <!-- -->
  <msxsl:script language="javascript" implements-prefix="user">
   function IsServer(value)
   {
     if(value == "OPC_SERVER" || value == "MCP_SERVER" || value == "FSI_SERVER")
     {
       return true;
     }
     return false;
   }
   function IsRemoteKeypad(value)
   {
     if(value == "FPA5000_RK" || value == "FPA5000_RK-C")
     {
       return true;
     }
     return false;
   }
   function IsPanel(value)
   {
     if(value == "FPA5000" || value == "FPA5000-C" || value == "FPA1200_EN" || value == "FPA1200_EN-C" || value == "FPA1100_EN-C")
     {
       return true;
     }
     return false;
   }
   function IsHW_C(value)
   {
     if(value == "FPA5000-C" || value == "FPA5000_RK-C" || value == "FPA1200_EN-C" || value == "FPA1100_EN-C")
     {
       return true;
     }
     return false;
   }
   var maxVal = 0;
   function SetMax(value)
   {
     if(value > maxVal)
     {
       maxVal = value;
     }
     return true;
   }
   function ResetMax()
   {
     maxVal = 0;
     return true;
   }
   function GetMax()
   {
     return maxVal;
   }
   var currentAssignedCMServerVal = "0";
   function SetCurrentAssignedCMServer(value)
   {
	   currentAssignedCMServerVal = value;
	   return currentAssignedCMServerVal;
   }
   function GetCurrentAssignedCMServer()
   {
	   return currentAssignedCMServerVal;
   }
   var remoteServicesInserted = "0";
   function SetRemoteServicesInserted(value)
   {
	   remoteServicesInserted = value;
	   return remoteServicesInserted;
   }
   function GetRemoteServicesInserted()
   {
	   return remoteServicesInserted;
   }

   var highestRemoteOperatorLevel = "4";
   function SetHighestRemoteOperatorLevel(value)
   {
	   highestRemoteOperatorLevel = value;
	   return highestRemoteOperatorLevel;
   }
   function GetHighestRemoteOperatorLevel()
   {
	   return highestRemoteOperatorLevel;
   }



    </msxsl:script>
</xsl:stylesheet>
